const express = require("express");
const router = express.Router();
const { authenticateToken, requireRole } = require("../middleware/auth");
const { validateEmployer } = require("../config/validation");
const EmployerController = require("../controllers/employerController");

router.get("/", authenticateToken, EmployerController.getAllEmployers);
router.get("/:id", authenticateToken, EmployerController.getEmployerById);

router.post("/", authenticateToken, validateEmployer, EmployerController.createEmployer);

router.put("/:id", authenticateToken, validateEmployer, EmployerController.updateEmployer);

router.delete("/:id", authenticateToken, EmployerController.softDeleteEmployer);

router.post("/:id/undelete", authenticateToken, EmployerController.undeleteEmployer);

router.delete("/:id/permanent", authenticateToken, requireRole(["Admin"]), EmployerController.permanentDeleteEmployer);

module.exports = router;
