const express = require("express");
const router = express.Router();
const { authenticateToken } = require("../middleware/auth");
const DashboardController = require("../controllers/dashboardController");

router.get("/summary", authenticateToken, DashboardController.getSummary);
router.get("/export/excel", authenticateToken, DashboardController.exportExcel);
router.get("/export/pdf", authenticateToken, DashboardController.exportPdf);

module.exports = router;
