const express = require("express")
const { authenticateToken } = require("../middleware/auth")
const AuthController = require("../controllers/authController")
const { validateLogin } = require("../config/validation")

const router = express.Router()

router.post("/login", validateLogin, AuthController.login)
router.get("/verify", authenticateToken, AuthController.verify)
router.post("/logout", AuthController.logout)

module.exports = router
