const express = require("express")
const { authenticateToken, requireRole } = require("../middleware/auth")
const AgentController = require("../controllers/agentController")
const { validateAgent, validateCreateAgent, validateGroup } = require("../config/validation")

const router = express.Router()

// Group routes
router.get("/groups", authenticateToken, requireRole(["Admin"]), AgentController.getGroups)
router.post("/groups", authenticateToken, requireRole(["Admin"]), validateGroup, AgentController.createGroup)
router.put("/groups/:id", authenticateToken, requireRole(["Admin"]), validateGroup, AgentController.updateGroup)
router.delete("/groups/:id", authenticateToken, requireRole(["Admin"]), AgentController.deleteGroup)

// Agent routes
router.get("/", authenticateToken, requireRole(["Admin"]), AgentController.listAgents)
router.get("/:id", authenticateToken, requireRole(["Admin"]), AgentController.getAgentById)
router.post("/", authenticateToken, requireRole(["Admin"]), validateCreateAgent, AgentController.createAgent)
router.put("/:id", authenticateToken, requireRole(["Admin"]), validateAgent, AgentController.updateAgent)
router.delete("/:id", authenticateToken, requireRole(["Admin"]), AgentController.deleteAgent)
router.patch("/:id/can-skip-matricule", authenticateToken, requireRole(["Admin"]), AgentController.patchCanSkip)
router.patch("/:id/can-skip-matricule-admin", authenticateToken, requireRole(["Admin"]), AgentController.patchCanSkip)

module.exports = router
