
const sequelize = require("../config/database")
const User = require("./User")
const Employer = require("./Employer")
const Group = require("./Group")

// Associations
User.hasMany(Employer, {
  foreignKey: "agent_id",
  as: "employers",
})
Employer.belongsTo(User, {
  foreignKey: "agent_id",
  as: "agent",
})
Employer.belongsTo(User, {
  foreignKey: "deleted_by",
  as: "deletedByUser",
})

// User belongs to Group, Group has many Users
Group.hasMany(User, { foreignKey: "groupId", as: "users" });
User.belongsTo(Group, { foreignKey: "groupId", as: "group" });

module.exports = {
  sequelize,
  User,
  Employer,
  Group,
}
