const { DataTypes } = require("sequelize")
const sequelize = require("../config/database")

const Employer = sequelize.define(
  "Employer",
  {
    created_at: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: DataTypes.NOW,
    },
    updated_at: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: DataTypes.NOW,
    },
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    matricule: {
      type: DataTypes.STRING(50),
      allowNull: true,
      unique: true,
      validate: {
        len: [1, 50],
      },
    },
    employeur_nom: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    employeur_type: {
      type: DataTypes.STRING(50),
      allowNull: true,
      validate: {
        isIn: [[
          "Banque",
          "Pharmacie",
          "Super Marcher",
          "Station Service",
          "Restaurant",
          "Hôtel",
          "Clinique",
          "Bureau de Change",
          "Assurance",
          "Transport",
          "École",
          "Université",
          "Autre"
        ]],
      },
    },
    ville: {
      type: DataTypes.STRING(50),
      allowNull: true,
      defaultValue: "Nouakchott",
    },
    commerce_register: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: null,
    },
    secteur: {
      type: DataTypes.ENUM("Public", "Privé"),
      allowNull: false,
      validate: {
        isIn: [["Public", "Privé"]],
        notEmpty: true,
      },
    },
    nom_responsable: {
      type: DataTypes.STRING(100),
      allowNull: false,
      validate: {
        notEmpty: true,
        len: [1, 100],
      },
    },
    numero_telephone: {
      type: DataTypes.STRING(20),
      allowNull: false,
      validate: {
        notEmpty: true,
        len: [1, 20],
      },
    },
    latitude: {
      type: DataTypes.DECIMAL(10, 8),
      allowNull: false,
      validate: {
        min: -90,
        max: 90,
      },
    },
    longitude: {
      type: DataTypes.DECIMAL(11, 8),
      allowNull: false,
      validate: {
        min: -180,
        max: 180,
      },
    },
    agent_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: "users",
        key: "id",
      },
    },
    deleted: {
      type: DataTypes.BOOLEAN,
      allowNull: false,
      defaultValue: false,
    },
    deleted_by: {
      type: DataTypes.INTEGER,
      allowNull: true,
      references: {
        model: "users",
        key: "id",
      },
    },
  },
  {
    tableName: "employers",
    indexes: [
      {
        unique: true,
        fields: ["matricule"],
      },
      {
        fields: ["agent_id"],
      },
    ],
    timestamps: true,
    createdAt: "created_at",
    updatedAt: "updated_at",
  },
)

module.exports = Employer
