const { Employer, User } = require("../models")
const {
  ForbiddenError,
  InternalServerError,
  enumErrorMessages,
} = require("../errors")

const getEmployeursMap = async (req, res) => {
  try {
    if (req.user.role !== "Admin") {
      return res
        .status(403)
        .json(ForbiddenError(enumErrorMessages.MAP_ACCESS_DENIED))
    }

    const employeurs = await Employer.findAll({
      include: [{ model: User, as: "agent", attributes: ["username"] }],
      attributes: [
        "id",
        "matricule",
        "latitude",
        "longitude",
        "employeur_nom",
        "nom_responsable",
        "agent_id",
      ],
    })

    const result = employeurs.map((e) => ({
      id: e.id,
      matricule: e.matricule,
      latitude: parseFloat(e.latitude),
      longitude: parseFloat(e.longitude),
      employeur_nom: e.employeur_nom,
      nom_responsable: e.nom_responsable,
      agentName: e.agent ? e.agent.username : undefined,
    }))

    res.json(result)
  } catch (err) {
    console.error("Erreur carte :", err)
    res
      .status(500)
      .json(
        InternalServerError(enumErrorMessages.MAP_FETCH_ERROR, err.message)
      )
  }
}

module.exports = { getEmployeursMap }
